#########################################################################################
### 
###		Configuracin desatendida de servidores VMware ESXi 5
### 
### 	Fecha Enero 2013
### 
### 	www.elblogdenegu.com
### 
### 	Version 0.1
### 
#########################################################################################

## Declaracin de variables

## CAMBIAR NOMBRE DE SERVIDOR Y PASSWORD

$NombreServidor = "esxi01.localdomain.local"
$NuevaPasswordroot = "VMware2013"

$Usuarioroot = "root"
$Passwordroot = "vmware"

## No modificar
$vCenter = "vcenter01.localdomain.local"
$ServidorSyslog = "syslog01.localdomain.local:514"
$NombreDatacenter = "Datacenter01"
$ServidorNTP = "es.pool.ntp.org"
$TipoLicenciaServidor = "VMware vSphere 5 Standard"
$ServidoresDNS = "192.168.1.2"
$NombreDominio = "localdomain.local"
$TiempoAutoarranque = 60
$DatastoreScratch = "Datastore01"
$GrupoAdministradores = "VMwareAdministradores"
$Usuarioroot = "root"
$Passwordroot = "vmware"
## Fin Declaracin de variables

#########################################
#Nos conectamos al servidor vCenter
$ConexionVCenter = Connect-VIServer $vCenter

Write-Host -foregroundcolor green "Inicio de la configuracin del servidor $NombreServidor"

#Aadimos el servidor al vCenter
Write-Host -foregroundcolor green "- Aadimos el servidor al vCenter"
$ServidorHostAdd = Add-VMHost -Name $NombreServidor -Force -Location (get-datacenter $NombreDatacenter) -User $Usuarioroot -Password $Passwordroot 

#Obtenemos el objeto
$ServidorHost = Get-VMHost $NombreServidor

#Lo sacamos del modo mantenimiento si lo est
Write-Host -foregroundcolor green "- Lo sacamos de modo mantenimiento"
$ServidorHost | Set-VMHost -State connected  | out-null




#########################################



#########################################
#Configuracion Licencias
#Requisito: 1 clave de licencia por cada tipo (Enterprise o Standard)
Write-Host -foregroundcolor green "- Configuracin de la licencia"
#Obtenemos la instancia del servidor
$ServidorInstancia = Get-View ServiceInstance 

#Obtenemos el objeto de administracion de las licencias
$LicenciaManager = Get-View $ServidorInstancia.Content.licenseManager 
$LicenciaManagerAsignacion = Get-View $LicenciaManager.licenseAssignmentManager   

#Obtenemos las licencias
$Licencias = $LicenciaManager.Licenses
#Tenemos que eleguir la licencia correspondiente al host
$LicenciaServidor = $LicenciaManager.Licenses | where {$_.Name -eq $TipoLicenciaServidor}

#Obtenemos la clave de cada licencia
$LicenciaServidorClave = $LicenciaServidor.LicenseKey

#Obtenemos el id del host
$ServidorHostView = Get-VMHost $NombreServidor | Get-View
$ServidorHostId = $ServidorHostView.Config.Host.Value

#Asignamos la licencia
$Licencia = New-Object VMware.Vim.LicenseManagerLicenseInfo 
$Licencia.LicenseKey = $LicenciaServidorClave
$ServidorLicencia = $LicenciaManagerAsignacion.UpdateAssignedLicense($ServidorHostId, $Licencia.LicenseKey,$null)
#Fin Configuracion Licencias
#########################################


#########################################
#Configuracion NTP
Write-Host -foregroundcolor green "- Configuracin NTP"
#Aadimos el servidor NTP
$ServidorNTPAdd = Add-VmHostNtpServer -NtpServer $ServidorNTP -VMHost $ServidorHost
#Reiniciamos el servicio
$ServidorNTPStart = Get-VmHostService -VMHost $ServidorHost | Where-Object {$_.key -eq "ntpd"} | Restart-VMHostService -Confirm:$false
#Lo configuramos como automatico
$ServidorNTPAuto = Get-VmHostService -VMHost $ServidorHost | Where-Object {$_.key -eq "ntpd"} | Set-VMHostService -Policy automatic

#Fin Configuracion NTP
#########################################


#########################################
#Configuracion DNS y Routing

Write-Host -foregroundcolor green "- Configuracion de DNS y Routing"
$vmHostNetworkInfo = Get-VmHostNetwork -VMHost $ServidorHost
$ServidorRedDNS = Set-VmHostNetwork -Network $vmHostNetworkInfo -DNSAddress $ServidoresDNS -DomainName $NombreDominio -SearchDomain $NombreDominio

#Fin Configuracion DNS y Routing
#########################################


#########################################
#Integracion con Directorio Activo
Write-Host -foregroundcolor green "- Integracion con Directorio Activo: Introduce el usuario sin el dominio"

$ServidorHostAuth=get-vmhostauthentication -VMhost $ServidorHost
$ServidorHostAuthDA = Set-vmhostauthentication -Domain $NombreDominio -JoinDomain -VMHostAuthentication $ServidorHostAuth -Confirm:$false 

#Fin Integracion con Directorio Activo
#########################################


#########################################
#Administradores
$opcion = "Config.HostAgent.plugins.hostsvc.esxAdminsGroup"
$valor = $GrupoAdministradores

$grupoadmins = get-AdvancedSetting -Entity $NombreServidor -Name $opcion | set-advancedSetting -Value $valor -confirm:$false
#Fin Administradores
#########################################

#########################################
#Configuracion de Autoarranque de maquinas
Write-Host -foregroundcolor green "- Configuracion del autoarranque de las maquinas"

$ServidorHostStartPolicy = get-vmhoststartpolicy  -VMhost $ServidorHost
$ServidorHostStartPolicyVM = set-vmhoststartpolicy -vmhoststartpolicy $ServidorHostStartPolicy -Enabled:$true -StartDelay $TiempoAutoarranque -StopAction GuestShutDown -StopDelay $TiempoAutoarranque -WaitForHeartBeat:$true

#Fin Configuracion de Autoarranque de maquinas
#########################################


#########################################
#Configuracion ScratchConfig
Write-Host -foregroundcolor green "- Configuracion de Scratch"
$CarpetaScratch = "vmstore:"+$NombreDatacenter+"\"+$DatastoreScratch+"\.scratch-"+$NombreServidor
mkdir $CarpetaScratch

$opcion = "ScratchConfig.ConfiguredScratchLocation"
$valor = "/vmfs/volumes/"+$DatastoreScratch+"/.scratch-"+$NombreServidor

$ServidorSratch = get-AdvancedSetting -Entity $NombreServidor -Name $opcion | set-advancedSetting -Value $valor -confirm:$false
#Fin Configuracion ScratchConfig
#########################################


#########################################
#Configuracion Syslog
Write-Host -foregroundcolor green "- Configuracion del servidor Syslog"
$ServidorHostSyslog = Set-VMHostSysLogServer -VMHost $ServidorHost -SysLogServer $ServidorSyslog

#Abrimos el cortafuegos
$syslogFirewallExceptions = Get-VMHostFirewallException -VMHost $ServidorHost | where {$_.Name.StartsWith('syslog')}
$syslogFirewallExceptions | Set-VMHostFirewallException -Enabled $true

#Cambiamos el nivel de los logs
$opcion = "Config.HostAgent.log.level"
$valor = "error"
$errorlevel = get-AdvancedSetting -Entity $NombreServidor -Name $opcion | set-advancedSetting -Value $valor -confirm:$false

$opcion2 = "Vpx.Vpxa.config.log.level"
$valor2 = "error"
$errorlevel = get-AdvancedSetting -Entity $NombreServidor -Name $opcion2 | set-advancedSetting -Value $valor2 -confirm:$false

#Fin Configuracion Syslog
#########################################

#########################################
#Configuracion del almacenamiento como Round Robin
$hostview = get-view $ServidorHost.Id
$storageSystem = get-view $hostView.ConfigManager.StorageSystem
$policy = new-object VMware.Vim.HostMultipathInfoLogicalUnitPolicy
$policy.policy = "rr"
$storageSystem.StorageDeviceInfo.MultipathInfo.lun | where { $_.Path.length -gt 1 } | foreach { $storageSystem.SetMultipathLunPolicy($_.ID, $policy) }
#Fin Configuracion del almacenamiento
#########################################

#########################################
#Configuracion de la red
#Creamos el segundo vSwitch

$vSwitch1 = New-VirtualSwitch -VMHost $ServidorHost -name vSwitch1 -confirm:$false
#Configuracion de seguridad
#esxcli network vswitch standard policy security set --allow-forged-transmits yes --allow-mac-change yes --allow-promiscuous no --vswitch-name vSwitch0

#Creamos los grupos de puertos
Get-VirtualSwitch -VMHost $ServidorHost -Name vSwitch1 | New-VirtualPortGroup -Name "VMWARE-Interna" | out-null

Get-VirtualSwitch -VMHost $ServidorHost -Name vSwitch0 | New-VirtualPortGroup -Name "BE01" -VLANID 101 | out-null
Get-VirtualSwitch -VMHost $ServidorHost -Name vSwitch0 | New-VirtualPortGroup -Name "BE02" -VLANID 102 | out-null

#Creamos un grpo de puertos de monitorizacion en modo promiscuo
Get-VirtualSwitch -VMHost $ServidorHost -Name vSwitch0 | New-VirtualPortGroup -Name "Monitorizacion" -VLANID 4095 | out-null
$GrupoPuertos = Get-VirtualPortGroup -VMHost $ServidorHost -Name "Monitorizacion"
$GrupoPuertosSpec = New-Object VMware.Vim.HostPortGroupSpec
$GrupoPuertosSpec.Name="Monitorizacion"
$GrupoPuertosSpec.VlanId=4095
$GrupoPuertosSpec.VswitchName="vSwitch0"
$GrupoPuertosSpec.Policy = New-Object VMware.Vim.HostNetworkPolicy
$GrupoPuertosSpec.policy.security = New-Object VMware.Vim.HostNetworkSecurityPolicy
$GrupoPuertosSpec.policy.security.allowPromiscuous = $true
$ServidorHostVista = get-view $ServidorHost
$ServidorHostconfig=$ServidorHostVista.configmanager
$ServidorHostsys=$ServidorHostconfig.networksystem
$ServidorHostsysvista=get-view $ServidorHostsys
$ServidorHostsysvista.UpdatePortGroup($GrupoPuertos.Name,$GrupoPuertosSpec)

#Creamos un grupo de puertos con trfico limitado
Get-VirtualSwitch -VMHost $ServidorHost -Name vSwitch0 | New-VirtualPortGroup -Name "FE01" -VLANID 103 | out-null
$GrupoPuertos = Get-VirtualPortGroup -VMHost $ServidorHost -Name "FE01"
$GrupoPuertosSpec = New-Object VMware.Vim.HostPortGroupSpec
$GrupoPuertosSpec.Name="FE01"
$GrupoPuertosSpec.VlanId=103
$GrupoPuertosSpec.VswitchName="vSwitch0"
$GrupoPuertosSpec.Policy = New-Object VMware.Vim.HostNetworkPolicy
$GrupoPuertosSpec.policy.ShapingPolicy = New-Object VMware.Vim.HostNetworkTrafficShapingPolicy
$GrupoPuertosSpec.policy.ShapingPolicy.Enabled = $true
$GrupoPuertosSpec.policy.ShapingPolicy.AverageBandwidth = 100000000
$GrupoPuertosSpec.policy.ShapingPolicy.PeakBandwidth = 100000000
$GrupoPuertosSpec.policy.ShapingPolicy.BurstSize = 104857600
$ServidorHostVista = get-view $ServidorHost
$ServidorHostconfig=$ServidorHostVista.configmanager
$ServidorHostsys=$ServidorHostconfig.networksystem
$ServidorHostsysvista=get-view $ServidorHostsys
$ServidorHostsysvista.UpdatePortGroup($GrupoPuertos.Name,$GrupoPuertosSpec)

#########################################




#Ponemos en modo mantenimiento
$ServidorHost | Set-VMHost -State maintenance  | out-null

Disconnect-VIServer $vCenter -Confirm:$False

#########################################
#Cambiamos la password del root del servidor
Connect-VIServer -Server $NombreServidor -User $Usuarioroot -Password $Passwordroot

Set-VMHostAccount -UserAccount $Usuarioroot -Password $NuevaPasswordroot

Disconnect-VIServer -Server $NombreServidor -Confirm:$False

#Fin Cambiamos la password del root del servidor
#########################################


##################################################a#######################################
