########################################################################################################
#
#	Inventario de granja Citrix XenApp 6.5
#
#	Fecha: 2012/12/31
#
#
########################################################################################################


## Obtenemos el nombre del servidor
param( [string] $Servidor_DC)

if ($Servidor_DC -eq "")
{
	Write-Host
	Write-Host
	Write-Host "Debes introducir correctamente los parametros necesarios" -ForegroundColor Yellow
	Write-Host " powershell.exe Inventario-HTML-Remoto-v0.1.ps1 Servidor_DC" -ForegroundColor Yellow
	Write-Host
	Write-Host
	exit
}

####################################################
#Importamos los snapin de Citrix
Add-PSSnapin Citrix.Common.Commands
Add-PSSnapin Citrix.XenApp.Commands
Add-PSSnapin Citrix.Common.GroupPolicy
#Imortamos el mdulo para gestionar las Directivas previamente lo hemos tenido que copiar a la carpeta de modulos de PowerShell
Import-Module Citrix.GroupPolicy.Commands -Force


####################################################
#Declaracin de constantes
##Contenido HTML
$HTML_Report = ""
#
####################################################

####################################################
#Declaracion de variables

####################################################


####################################################
#Funciones para gestionar la salida HTML



##########################
function InsertarCabeceraHTML
{
	#Preparar HTML_report

	$HTML_Report = "<html>`n"
	$HTML_Report += "<head>`n"
	$HTML_Report += "<style type=`"text/css`"> table.tableCitrix {font-family:arial;background-color: #CDCDCD;margin:10px 0pt 15px;font-size: 8pt;width: 100%;	text-align: left;}</style>`n"
	$HTML_Report += "<style type=`"text/css`"> table.tableCitrix thead tr th, table.tableCitrix tfoot tr th {	background-color: #E6EEEE;	border: 1px solid #FFF;	font-size: 8pt;	padding: 4px;}</style>`n"
	$HTML_Report += "<style type=`"text/css`"> table.tableCitrix tbody td {	color: #3D3D3D;	padding: 4px;	background-color: #FFF;	vertical-align: top;}</style>`n"
	$HTML_Report += "</head>`n"
	$HTML_Report += "<body>`n"
	return $HTML_Report
}

function InsertarMenuHTML
{
	$HTML_Report += "`n"
	return $HTML_Report
}

function InsertarTituloHTML ($HTML_Report,$Titulo)
{
	$HTML_Report += "<h1><a name=`"$Titulo`">$Titulo</a></h1>`n"
	return $HTML_Report
}

function InsertarTextoHTML ($HTML_Report,$Texto)
{
	$HTML_Report += "<p>$Texto</p>`n"
	return $HTML_Report
}

function InsertarFinHTML ($HTML_Report)
{
	$HTML_Report += "<p>Documento creado por XXXX a las </p>`n"
	$HTML_Report += "</body>`n"
	$HTML_Report += "</html>`n"
	return $HTML_Report
}

function InsertarTablaHTML ($HTML_Report, $Titulo, $TituloColumnas, $PropiedadesColumnas, $Contenido)
{
	#Contamos el nmero de columnas
	$ColumnasNum = $TituloColumnas.Count

	#Preparamos la tabla
	$HTML_Report += "<table id=`"$Titulo`" class=`"tableCitrix`">`n"

	#Insertamos los titulos de las columnas
	
	$HTML_Report += "<thead>`n<tr>`n"
	for ($col = 0; $col -lt $ColumnasNum; $col++) {
		$a = $TituloColumnas[$col]
    	$HTML_Report += "<th>$a</th>`n"
	}
	$HTML_Report += "</tr>`n</thead>`n"
	

	#Aadimos los datos a la tabla
	$i = 1
	$j = $Contenido.Count
	
	for($row = 0; $row -lt $Contenido.Count; $row++)
	{
		$HTML_Report += "<tr>`n"
  		for ($col = 0; $col -lt $ColumnasNum; $col++){
			$a = $Contenido[$row].($PropiedadesColumnas[$col])
			
			$b = $a.ToString().replace("\n","<br/>")
			$c = $b.replace("\t","&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; - ")
			$HTML_Report += "<td>$c</td>`n"
		}
		$HTML_Report += "</tr>`n"
	}
	
	#Finalizamos la tabla
	$HTML_Report += "</table>`n"
	$HTML_Report += "<a href=`"#Menu`">[Menu]</a>`n"
	return $HTML_Report
}


#########################
#
function InsertarMenuHTML ($HTML_Report, $Enlaces)
{
	$HTML_Report += "<a name=`"Menu`"></a>"
	$HTML_Report += "<table id=`"Menu`" class=`"tableCitrix`">`n"
	$HTML_Report += "<tr>`n"
	
	foreach ($Enlace in $Enlaces)
	{
		$HTML_Report += "<td>`n"
		$HTML_Report += "<a href=`"#$Enlace`">$Enlace</a>"
		$HTML_Report += "</td>`n"
	}
	$HTML_Report += "</tr>`n"
	$HTML_Report += "</table>`n"
	return $HTML_Report
}



####Administradores
$Administradores = Get-XAAdministrator -Computername $Servidor_DC | sort-object AdministratorName
$AdministradoresContenido = @()
Foreach ($Administrador in $Administradores)
{
	$Admin = "" | select-Object Administrador, Tipo, Habilitado, PermGranja, PermCarpetas
	
	$Admin.Administrador = $Administrador.AdministratorName
	$Admin.Tipo = $Administrador.AdministratorType
	$Admin.Habilitado = $Administrador.Enabled
	
	If ($Admin.Tipo -eq "Custom")
	{
		$Admin.PermGranja = ""
		Foreach ($PermisoGranja in $Administrador.FarmPrivileges)
		{
			$Admin.PermGranja += "$PermisoGranja\n"
		}
		
		
		$Admin.PermCarpetas = ""
		$AdministradorPermisos = $Administrador.FolderPrivileges | Sort-Object FolderPath
		Foreach ($PermisoCarpeta in $AdministradorPermisos)
		{
			$Permiso = $PermisoCarpeta.ToString()
			$Carpeta = $Permiso.substring(0,$Permiso.IndexOf(":") + 1)
			$Admin.PermCarpetas += "$Carpeta\n"
						
			$Permisos = $Permiso.substring($Permiso.IndexOf(":") +1)
			$PermisosSalida = $Permisos.replace(",","\n\t")
			$Admin.PermCarpetas += "\t$PermisosSalida\n"

		}
	}
	Else
	{	
		$Admin.PermGranja = ""
		$Admin.PermCarpetas = ""	
	}
	
	$AdministradoresContenido += $Admin
}
####Fin Administradores


####Aplicaciones
$AplicacionesContenido = @()
$AplicacionesReport = Get-XAApplicationReport -Computername $Servidor_DC *
foreach ($AppReport in $AplicacionesReport)
{
	$Aplicacion = "" | Select-Object Nombre, Tipo, Carpeta, Comando, Directorio, Usuarios, Grupos, Servidores, Audio, Encriptacion, Resolucion, Color, Habilitada
	
	$Aplicacion.Nombre = $AppReport.BrowserName
	$Aplicacion.Carpeta = $AppReport.FolderPath
	
	$Aplicacion.Habilitada = $AppReport.Enabled
	
	#Revisamos el tipo de aplicacion
	If ($AppReport.ApplicationType -eq "Content")
	{
		$Aplicacion.Tipo = "Contenido"
		$Aplicacion.Comando = $AppReport.ContentAddress
		
		$Aplicacion.Directorio = "No aplica"
		$Aplicacion.Audio = "No aplica"
		$Aplicacion.Encriptacion = "No aplica"
		$Aplicacion.Resolucion = "No aplica"
		$Aplicacion.Color = "No aplica"
		$Aplicacion.Grupos = "No aplica"
		$Aplicacion.Servidores = "No aplica"
	}
	If ($AppReport.ApplicationType -eq "ServerInstalled")
	{
		$Aplicacion.Tipo = "Instalada en servidor"
		$Aplicacion.Comando = $AppReport.CommandLineExecutable
		$Aplicacion.Directorio = $AppReport.WorkingDirectory
		
		$Aplicacion.Audio = $AppReport.AudioType
		$Aplicacion.Encriptacion = $AppReport.EncryptionLevel
		$Aplicacion.Resolucion = $AppReport.WindowType
		$Aplicacion.Color = $AppReport.ColorDepth
		
		if ($AppReport.WorkerGroupNames)
		{
			$Aplicacion.Grupos = ""
			foreach ($grupo in $AppReport.WorkerGroupNames)
			{
				$Aplicacion.Grupos += $grupo + "\n"
			}
		}
		else
		{
			$Aplicacion.Grupos = "No hay grupos de servidores\n"
		}
		
		If ($AppReport.ServerNames)
		{
			$Aplicacion.Servidores = ""
			foreach ($Servidor in $AppReport.ServerNames)
			{
				$Aplicacion.Servidores += $Servidor
			}
		}
		else
		{
			$Aplicacion.Servidores = "No hay servidores\n"
		}
		
	}
	If ($AppReport.ApplicationType -eq "StreamedToServer")
	{
		$Aplicacion.Tipo = "Streaming"
		$Aplicacion.Directorio = "No aplica"
		$Aplicacion.Audio = "No aplica"
		$Aplicacion.Encriptacion = "No aplica"
		$Aplicacion.Resolucion = "No aplica"
		$Aplicacion.Color = "No aplica"
		$Aplicacion.Grupos = "No aplica"
		$Aplicacion.Servidores = "No aplica"
		$Aplicacion.Comando = "No aplica"
	}

	
	
	
	
	$Aplicacion.Usuarios = ""
	foreach ($usuario in $AppReport.accounts)
	{
		$Aplicacion.Usuarios += $usuario.AccountDisplayName + "\n"
	}
	
	$AplicacionesContenido += $Aplicacion
}
####Fin Aplicaciones



####Obtenemos las Directivas de Equilibrio de Carga
$Directivas = Get-XALoadBalancingPolicy -Computername $Servidor_DC | Sort-Object Priority

If ($Directivas)
{
	$DirectivasEquilibrioContenido = @()
	Foreach ($Directiva in $Directivas)
	{
		$Direc = "" | select-Object Nombre, Descripcion, Habilitado, Prioridad, FiltroAC, FiltroIP, FiltroNombre, FiltroUsuario, Preferencia

		$DirectivaConfiguracion = Get-XALoadBalancingPolicyConfiguration -PolicyName $Directiva.PolicyName -Computername $Servidor_DC
	    $DirectivaFiltro = Get-XALoadBalancingPolicyFilter -PolicyName $Directiva.PolicyName -Computername $Servidor_DC
	 
		$Direc.Nombre = $Directiva.PolicyName
		$Direc.Descripcion = $Directiva.Description
		$Direc.Habilitado = $Directiva.Enabled
		$Direc.Prioridad = $Directiva.Priority

		#Filtro AC
		If($DirectivaFiltro.AccessControlEnabled)
		{
			If($DirectivaFiltro.AllowConnectionsThroughAccessGateway)
			{
				If($DirectivaFiltro.AllowOtherConnections)
				{
					$Direc.FiltroAC = "Aplicar a todas las dems conexiones"
				}
				Else
				{
					$Direc.FiltroAC =  "Filtro:\n"
					If($DirectivaFiltro.AccessSessionConditions)
					{
						ForEach($AccessSessionCondition in $DirectivaFiltro.AccessSessionConditions)
						{
							$FiltroAC += "\t" + $AccessSessionCondition + "\n"
						}
					}	
				}
			}
		}
		Else
		{
			$Direc.FiltroAC = "No hay Filtro AC\n"
		}
		
		#Filtro Direccion IP
		If($DirectivaFiltro.ClientIPAddressEnabled)
		{
			If($DirectivaFiltro.ApplyToAllClientIPAddresses)
			{
				$Direc.FiltroIP = "Aplicar a todas las IPs"
			}
			Else
			{
				If($DirectivaFiltro.AllowedIPAddresses)
				{
					$Direc.FiltroIP = "IPs Permitidas\n"
					ForEach($AllowedIPAddress in $DirectivaFiltro.AllowedIPAddresses)
					{
						$Direc.FiltroIP += "\t" + $AllowedIPAddress + "\n"
					}
				}
				If($DirectivaFiltro.DeniedIPAddresses)
				{
					$Direc.FiltroIP += "IPs Ignoradas\n"
					ForEach($DeniedIPAddress in $DirectivaFiltro.DeniedIPAddresses)
					{
						$Direc.FiltroIP += "\t" + $DeniedIPAddress + "\n"
					}
				}
			}
		}
		Else
		{
			$Direc.FiltroIP = "No hay Filtro de IP\n"
		}
		
		#Filtro de Nombre del cliente
		If($DirectivaFiltro.ClientNameEnabled)
		{
			If($DirectivaFiltro.ApplyToAllClientNames)
			{
				$Direc.FiltroNombre = "Aplicar a todos los clientes\n"
			}
			Else
			{
				
				If($DirectivaFiltro.AllowedClientNames)
				{
					$Direc.FiltroNombre += "Clientes permitidos:\n"
					ForEach($AllowedClientName in $DirectivaFiltro.AllowedClientNames)
					{
						$Direc.FiltroNombre += "<li>" + $AllowedClientName + "</li>"
					}
				}
				If($DirectivaFiltro.DeniedClientNames)
				{
					$Direc.FiltroNombre += "Clientes no permitidos:\n"
					ForEach($DeniedClientName in $DirectivaFiltro.DeniedClientNames)
					{
						$Direc.FiltroNombre += "\t" + $DeniedClientName + "\n"
					}
				}
			}
		}
		Else
		{
			$Direc.FiltroNombre = "No hay Filtro de Nombre del cliente\n"
		}
			
		
		
		#Filtro de Usuarios
		If($DirectivaFiltro.AccountEnabled)
		{
			If($DirectivaFiltro.ApplyToAnonymousAccounts)
			{
				$Direc.FiltroUsuario = "Usuarios Anonimos permitidos\n"
			}
			
			If($DirectivaFiltro.ApplyToAllExplicitAccounts)
			{
				$Direc.FiltroUsuario = "Aplicar a los siguientes usuarios:" + $DirectivaFiltro.ApplyToAllExplicitAccounts + "\n"
			}
			Else
			{
				If($DirectivaFiltro.AllowedAccounts)
				{
					$Direc.FiltroUsuario  += "Usuarios Permitidos:\n"
					ForEach($AllowedAccount in $DirectivaFiltro.AllowedAccounts)
					{
						$Direc.FiltroUsuario  += "\t" +  $AllowedAccount + "\n"
					}
				}
				If($DirectivaFiltro.DeniedAccounts)
				{
					$Direc.FiltroUsuario  += "Usuarios denegados:\n"				
					ForEach($DeniedAccount in $DirectivaFiltro.DeniedAccounts)
					{
						$Direc.FiltroUsuario  += "\t" + $DeniedAccount + "\n"
					}
				}
			}
		}
		Else
		{
			$Direc.FiltroUsuario = "\tNo hay Filtro de Usuarios\n"
		}
		
		
		#Configuracion de Prioridades de servidores

		If($DirectivaConfiguracion.WorkerGroupPreferenceAndFailoverState)
		{
			If($DirectivaConfiguracion.WorkerGroupPreferences)
			{
				ForEach($WorkerGroupPreference in $DirectivaConfiguracion.WorkerGroupPreferences)
				{
	                    $Direc.Preferencia += "$WorkerGroupPreference\n"
				}
			}
		}

		#Aadimos la directiva al array
		$DirectivasEquilibrioContenido += $Direc
		
	}

}
####Fin de las Directivas de Equilibrio de Carga



####Grupos de Trabajo
$Grupos = Get-XAWorkerGroup -Computername $Servidor_DC | sort-object WorkerGroupName
$GruposDeServidoresContenido = @()
Foreach ($Grupo in $Grupos)
{
	$Grup = "" | select-Object Nombre, Descripcion, Servidores, Aplicaciones

	$Grup.Nombre = $Grupo.WorkerGroupName
	$Grup.Descripcion = $Grupo.Description
	
	$Servidores = ""
	If($Grupo.ServerNames)
	{
		$ServidoresOrd = $Grupo.ServerNames | Sort
		$Grup.Servidores += "Servidores de la granja:\n"
		foreach($Servidor in $ServidoresOrd)
		{
			$Grup.Servidores += "\t" + $Servidor + "\n"
		}
	}
	If($Grupo.ServerGroups)
	{
		$ServidoresOrd = $Grupo.ServerGroups | Sort
		$Grup.Servidores += "Servidores de los grupos:\n"
		foreach($Servidor in $ServidoresOrd)
		{
			$Grup.Servidores += "\t" + $Servidor + "\n"
		}
	}
	If($Grupo.OUs)
	{
		$ServidoresOrd = $Grupo.OUs | Sort
		$Grup.Servidores += "Servidores de las OUs:\n"
		foreach($Servidor in $ServidoresOrd)
		{
			$Grup.Servidores += "\t" + $Servidor + "\n"
		}
	}
	If ((-not $Grupo.ServerNames) -and (-not $Grupo.ServerGroups) -and (-not $Grupo.OUs))
	{
		$Grup.Servidores = "No hay servidores\n"
	}
	
	$Aplicaciones = Get-XAApplication -Computername $Servidor_DC -WorkerGroup $Grupo.WorkerGroupName | Sort-Object BrowserName
	$Grup.Aplicaciones = ""
	foreach ($Aplicacion in $Aplicaciones)
	{
		$Grup.Aplicaciones += $Aplicacion.BrowserName + "\n"
	}
	
	
	$GruposDeServidoresContenido += $Grup
}
####Fin Grupos de Trabajo


####Patrones de Carga
$Patrones = Get-XALoadEvaluator -Computername $Servidor_DC | sort-object LoadEvaluatorName
$PatronesContenido = @()
Foreach ($Patron in $Patrones)
{
	$Patro = "" | select-Object Nombre, Descripcion, Tipo, Reglas
	
	$Patro.Nombre = $Patron.LoadEvaluatorName
	$Patro.Descripcion = $Patron.Description
	
	If($Patron.IsBuiltIn)
	{
		$Patro.Tipo = "Sistema"
	}
	else
	{
		$Patro.Tipo = "Usuario"
	}
	
	If($Patron.ApplicationUserLoadEnabled)
	{
		$usuarios = $Patron.ApplicationUserLoad
		$app = $Patron.ApplicationBrowserName
		$Patro.Reglas += "Carga de Usuarioes en la aplicacion:  $usuarios usuarios en la aplicacin $app\n"
	}
	else
	{
		
	}
	If($Patron.ContextSwitchesEnabled)
	{
		$min = $Patron.ContextSwitches[0]
		$max = $Patron.ContextSwitches[1]
		$Patro.Reglas += "Cambios de contexto: entre $min y $max\n"
	}
	else
	{
		
	}
	If($Patron.CpuUtilizationEnabled)
	{
		$min = $Patron.CPUUtilization[0]
		$max = $Patron.CPUUtilization[1]
		$Patro.Reglas += "Utilizacin de CPU: entre $min y $max \n"
	}
	else
	{
		
	}
	If($Patron.DiskDataIOEnabled)
	{
		$min = $Patron.DiskDataIO[0]
		$max = $Patron.DiskDataIO[1]
		$Patro.Reglas += "E/S de datos en disco: entre $min y $max \n"
	}
	else
	{
		
	}
	If($Patron.DiskOpeartionsEnabled)
	{
		$min = $Patron.DiskOperations[0]
		$max = $Patron.DiskOperations[1]
		$Patro.Reglas += "Operaciones en disco: entre $min y $max \n"
	}
	else
	{
		
	}
	If($Patron.IPRangesEnabled)
	{
		$Patro.Reglas += "Intervalo IP\n"
	}
	else
	{
		
	}
	If($Patron.LoadThrottlingEnabled)
	{
		$valor = $Patron.LoadThrottling
		$Patro.Reglas += "Regulacin de carga: $valor\n"
	}
	else
	{
		
	}
	If($Patron.MemoryUsageEnabled)
	{
		$min = $Patron.MemoryUsage[0]
		$max = $Patron.MemoryUsage[1]
		$Patro.Reglas += "Utilizacin de memoria: entre $min y $max \n"
	}
	else
	{
		
	}
	If($Patron.PageFaultsEnabled)
	{
		$min = $Patron.PageFaults[0]
		$max = $Patron.PageFaults[1]
		$Patro.Reglas += "Errores de pgina: entre $min y $max \n"
	}
	else
	{
		
	}
	If($Patron.PageSwapsEnabled)
	{
		$min = $Patron.PageSwaps[0]
		$max = $Patron.PageSwaps[1]
		$Patro.Reglas += "Intercambios de paginacin: entre $min y $max \n"
	}
	else
	{
		
	}
	If($Patron.ScheduleEnabled)
	{
		$Lunes = $Patron.MondaySchedule
		$Martes = $Patron.TuesdaySchedule
		$Miercoles = $Patron.WednesdaySchedule
		$Jueves = $Patron.ThursdaySchedule
		$Viernes = $Patron.FridaySchedule
		$Sabado = $Patron.SaturdaySchedule
		$Domingo = $Patron.SundaySchedule
	
		$Patro.Reglas += "Programacin\n"
		$Patro.Reglas += "\tLunes: $Lunes\n"
		$Patro.Reglas += "\tMartes: $Martes\n"
		$Patro.Reglas += "\tMiercoles: $Miercoles \n"
		$Patro.Reglas += "\tJueves: $Jueves\n"
		$Patro.Reglas += "\tViernes: $Viernes\n"
		$Patro.Reglas += "\tSabado: $Sabado\n"
		$Patro.Reglas += "\tDomingo: $Domingo\n"
	}
	else
	{
		
	}
	If($Patron.ServerUserLoadEnabled)
	{
		$valor =  $Patron.ServerUserLoad
		$Patro.Reglas += "Carga de usuarios en el servidor: $valor\n"
	}
	else
	{
		
	}
	
	$PatronesContenido += $Patro
}
####Fin Patrones de Carga

####Servidores
$Servidores = Get-XAServer -Computername $Servidor_DC | sort-object ServerName
$ServidoresContenido = @()
Foreach ($Servidor in $Servidores)
{
	$Serv = "" | select-Object Nombre, Citrix, SistemaOperativo, Carpeta, Zona, Eleccion, Hotfixes
	#Formateamos la salida
	$Serv.Nombre= $Servidor.ServerName
	
	$ServidorCitrix = $Servidor.CitrixProductName + ", " + $Servidor.CitrixVersion + ", " + $Servidor.CitrixEdition + ", " + $Servidor.CitrixServicePack
	$Serv.Citrix += "$ServidorCitrix"
	
	$SO=$Servidor.OSVersion.ToString() + ", " + $Servidor.OSServicePack
	$Serv.SistemaOperativo = $SO
	
	$Serv.Carpeta = $Servidor.FolderPath
	
	$Serv.Zona = $Servidor.ZoneName
	
	$Serv.Eleccion = $Servidor.ElectionPreference
		
	$Hotfixes = Get-XAServerHotfix -ServerName $Servidor.ServerName -Computername $Servidor_DC | sort-object Valid
	$Serv.Hotfixes = ""
	Foreach($hotfix in $hotfixes)
	{
		if ($hotfix.Valid)
		{
			$Serv.Hotfixes += "\t<b>" + $hotfix.HotfixName + "<b>\n"
		}
		else
		{
			$Serv.Hotfixes += "\t" + $hotfix.HotfixName + " (Reemplazado)\n"
		}
	}
	$ServidoresContenido += $Serv

}
####Fin Servidores




####Zonas
$ZonasContenido = @()
$Zonas = Get-XAZone -Computername $Servidor_DC
Foreach ($Zona in $Zonas)
{
	$Zon = "" | Select-Object Nombre, DC, Servidores
	
	$Zon.Nombre = $Zona.ZoneName
	$Zon.DC = $Zona.DataCollector
	
	$Servidores = Get-XAserver -Computername $Servidor_DC -ZoneName $Zona.ZoneName | Sort-Object
	
	ForEach ($Servidor in $Servidores)
	{
		$Zon.Servidores += $Servidor.ServerName + "(" + $Servidor.ElectionPreference + ")\n"
	}
	
	$ZonasContenido += $Zon

}
####FinZonas


####Directivas
#http://community.citrix.com/display/xa/Exporting+and+Importing+XenApp+Group+Policies
$PSCitrixGPO=New-PSDrive -Name CitrixGPO -PSProvider CitrixGroupPolicy -Root \ -FarmGPO $Servidor_DC -Scope Global
$Directivas = Get-CtxGroupPolicy -DriveName CitrixGPO
$DirectivasContenido = @()
ForEach ($Policy in $Directivas)
{
	$Directiva = "" | Select-Object Nombre, Descripcion, Tipo, Habilitada, Prioridad, Filtro, Configuracion
	
	$Filtros = Get-CtxGroupPolicyFilter -PolicyName $Policy.PolicyName -DriveName CitrixGPO
	$Configuracion = Get-CtxGroupPolicyConfiguration -PolicyName $Policy.PolicyName -DriveName CitrixGPO
	
	$Directiva.Nombre = $Policy.PolicyName
	$Directiva.Descripcion = $Policy.Description
	$Directiva.Tipo = $Policy.Type
	$Directiva.Habilitada = $Policy.Enabled
	$Directiva.Prioridad = $Policy.Priority
	
	$Directiva.Filtro = "Filtros: \n"
	if ($Filtros)
	{
		Foreach ($Filtro in $Filtros)
		{
			$Directiva.Filtro += "\tNombre: " + $Filtro.FilterName + "\n"
			$Directiva.Filtro += "\tTipo: " + $Filtro.Type + "\n"
			$Directiva.Filtro += "\tHabilitado: " + $Filtro.Enabled + "\n"
			$Directiva.Filtro += "\tModo: " + $Filtro.Mode + "\n"
			$Directiva.Filtro += "\tValor: " + $Filtro.FilterValue + "\n\n"
		}
	}
	Else
	{
		$Directiva.Filtro = "No hay Filtros\n"
	}
	
	$Directiva.Configuracion = ""
	#Procesamos la configuracion
	If ($Configuracion.Type -eq "Computer")
	{
		If (($Configuracion.Farmname.State -ne "NotConfigured") -or ($Configuracion.WorkLoadName.State -ne "NotConfigured"))
		{
			$Directiva.Configuracion += "Administracin de energa y capacidad\n"
			If ($Configuracion.Farmname.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tNombre de la comunidad: " + $Configuracion.Farmname.Value + "\n"
			}
			If ($Configuracion.WorkLoadName.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tNombre de la carga de trabajo: " + $Configuracion.WorkLoadName.Value + "\n"
			}
		}
		
		If (($Configuracion.LicenseServerHostName.State -ne "NotConfigured") -or ($Configuracion.LicenseServerPort.State -ne "NotConfigured"))
		{
			$Directiva.Configuracion += "Configuracin de licencias\n"
			If ($Configuracion.LicenseServerHostName.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tNombre del host del servidor de licencias: " + $Configuracion.LicenseServerHostName.Value + "\n"
			}
			If ($Configuracion.LicenseServerPort.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tPuerto del servidor de licencias: " + $Configuracion.LicenseServerPort.Value + "\n"
			}
		}
		
		
		If (($Configuracion.FullIconCaching.State -ne "NotConfigured") -or ($Configuracion.ConnectionAccessControl.State -ne "NotConfigured") -or ($Configuracion.ProductEdition.State -ne "NotConfigured") -or ($Configuracion.ProductModel.State -ne "NotConfigured") -or ($Configuracion.LoadEvaluator.State -ne "NotConfigured") -or ($Configuracion.DnsAddressResolution.State -ne "NotConfigured"))
		{
			$Directiva.Configuracion += "Configuracin del servidor\n"
			If ($Configuracion.FullIconCaching.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tAlmacenamiento completo de iconos en cach: " + $Configuracion.FullIconCaching.State + "\n"
			}
			If ($Configuracion.ConnectionAccessControl.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tControl de acceso de las conexiones: " + $Configuracion.ConnectionAccessControl.Value + "\n"
			}
			If ($Configuracion.ProductEdition.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tEdicion del producto XenApp: " + $Configuracion.ProductEdition.Value + "\n"
			}
			If ($Configuracion.ProductModel.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tModelo del producto XenApp: " + $Configuracion.ProductModel.Value + "\n"
			}
			If ($Configuracion.LoadEvaluator.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tNombre del patrn de carga: " + $Configuracion.LoadEvaluator.Value + "\n"
			}
			If ($Configuracion.DnsAddressResolution.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tResolucin de direcciones DNS: " + $Configuracion.DnsAddressResolution.State + "\n"
			}
		}
		
		If (($Configuracion.OfflineClientTrust.State -ne "NotConfigured") -or ($Configuracion.OfflineLicensePeriod.State -ne "NotConfigured") -or ($Configuracion.OfflineEventLogging.State -ne "NotConfigured") -or ($Configuracion.OfflineUsers.State -ne "NotConfigured"))
		{
			$Directiva.Configuracion += "Configuracin del servidor \ Aplicaciones sin conexin\n"
			If ($Configuracion.OfflineClientTrust.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tConfianza en clientes de aplicaciones sin conexin: " + $Configuracion.OfflineClientTrust.State + "\n"
			}
			If ($Configuracion.OfflineLicensePeriod.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tPeriodo de licencias de aplicaciones sin conexin: " + $Configuracion.OfflineLicensePeriod.Value + "\n"
			}
			If ($Configuracion.OfflineEventLogging.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tRegistro de sucesos de aplicaciones sin conexin: " + $Configuracion.OfflineEventLogging.State + "\n"
			}
			If ($Configuracion.OfflineUsers.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tUsuarios de aplicaciones sin conexin: " + $Configuracion.OfflineUsers.Values + "\n"
			}
		}
		
		If (($Configuracion.UserSessionLimit.State -ne "NotConfigured") -or ($Configuracion.UserSessionLimitAffectsAdministrators.State -ne "NotConfigured") -or ($Configuracion.UserSessionLimitLogging.State -ne "NotConfigured"))
		{
			$Directiva.Configuracion += "Configuracin del servidor \ Lmites de conexin\n"
			If ($Configuracion.UserSessionLimit.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tLimite de sesiones de usuario: " + $Configuracion.UserSessionLimit.Value + "\n"
			}
			If ($Configuracion.UserSessionLimitAffectsAdministrators.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tLimites de sesiones de administrador: " + $Configuracion.UserSessionLimitAffectsAdministrators.State + "\n"
			}
			If ($Configuracion.UserSessionLimitLogging.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tRegistro de sucesos de limites de inicios de sesion: " + $Configuracion.UserSessionLimitLogging.State + "\n"
			}
		}
		
		If (($Configuracion.MemoryOptimizationIntervalType.State -ne "NotConfigured") -or ($Configuracion.MemoryOptimizationExcludedPrograms.State -ne "NotConfigured") -or ($Configuracion.CpuManagementServerLevel.State -ne "NotConfigured") -or ($Configuracion.MemoryOptimization.State -ne "NotConfigured") -or ($Configuracion.MemoryOptimizationDayOfWeek.State -ne "NotConfigured") -or ($Configuracion.MemoryOptimizationDayOfMonth.State -ne "NotConfigured") -or ($Configuracion.MemoryOptimizationTime.State -ne "NotConfigured"))
		{
			$Directiva.Configuracion += "Configuracin del servidor \ Memoria/CPU\n"
			If ($Configuracion.MemoryOptimizationIntervalType.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tIntervalo de optimizacion de memoria: " + $Configuracion.MemoryOptimizationIntervalType.Value + "\n"
			}
			If ($Configuracion.MemoryOptimizationExcludedPrograms.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tLista de aplicaciones excluidas de la optimizacion de memoria: " + $Configuracion.MemoryOptimizationExcludedPrograms.Value + "\n"
			}
			If ($Configuracion.CpuManagementServerLevel.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tNivel de administracin de CPU de servidor: " + $Configuracion.CpuManagementServerLevel.Value + "\n"
			}
			If ($Configuracion.MemoryOptimization.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tOptimizacion de memoria: " + $Configuracion.MemoryOptimization.State + "\n"
			}
			If ($Configuracion.MemoryOptimizationDayOfWeek.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\t: " + $Configuracion.MemoryOptimizationDayOfWeek.Value + "\n"
			}
			If ($Configuracion.MemoryOptimizationDayOfMonth.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tProgramacion de la optimizacion de memoria: dia del mes: " + $Configuracion.MemoryOptimizationDayOfMonth.Value + "\n"
			}
			If ($Configuracion.MemoryOptimizationTime.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tProgramacion de la optimizacion de memoria: hora: " + $Configuracion.MemoryOptimizationTime.Value + "\n"
			}
		}
		
		If (($Configuracion.RebootWarningMessage.State -ne "NotConfigured") -or ($Configuracion.RebootCustomMessage.State -ne "NotConfigured") -or ($Configuracion.RebootWarningStartTime.State -ne "NotConfigured") -or ($Configuracion.RebootScheduleStartDate.State -ne "NotConfigured") -or ($Configuracion.RebootScheduleFrequency.State -ne "NotConfigured") -or ($Configuracion.RebootDisableLogOnTime.State -ne "NotConfigured") -or ($Configuracion.RebootScheduleTime.State -ne "NotConfigured") -or ($Configuracion.RebootWarningInterval.State -ne "NotConfigured") -or ($Configuracion.RebootScheduleRandomizationInterval.State -ne "NotConfigured") -or ($Configuracion.ScheduledReboots.State -ne "NotConfigured") -or ($Configuracion.RebootCustomMessageText.State -ne "NotConfigured"))
		{
			$Directiva.Configuracion += "Configuracin del servidor \ Reinicios\n"
			If ($Configuracion.RebootWarningMessage.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tAdvertencia de reinicios para los usuarios: " + $Configuracion.RebootWarningMessage.Value + "\n"
			}
			If ($Configuracion.RebootCustomMessage.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tAdvertencia personalizada de reinicio: " + $Configuracion.RebootCustomMessage.Value + "\n"
			}
			If ($Configuracion.RebootWarningStartTime.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tComienzo de advertencias de reinicio: " + $Configuracion.RebootWarningStartTime.Value + "\n"
			}
			If ($Configuracion.RebootScheduleStartDate.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tFecha de comienzo del reinicio programado: " + $Configuracion.RebootScheduleStartDate.Value + "\n"
			}
			If ($Configuracion.RebootScheduleFrequency.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tFrecuencia de reinicio programado: " + $Configuracion.RebootScheduleFrequency.Value + "\n"
			}
			If ($Configuracion.RebootDisableLogOnTime.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tHora de inhabilitacion de inicios de sesion por reinicio: " + $Configuracion.RebootDisableLogOnTime.Value + "\n"
			}
			If ($Configuracion.RebootScheduleTime.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tHora del reinicio programado: " + $Configuracion.RebootScheduleTime.Value + "\n"
			}
			If ($Configuracion.RebootWarningInterval.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tIntervalo de advertencias de reinicio: " + $Configuracion.RebootWarningInterval.Value + "\n"
			}
			If ($Configuracion.RebootScheduleRandomizationInterval.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tIntervalo de seleccin de hora de reinicio programado: " + $Configuracion.RebootScheduleRandomizationInterval.Value + "\n"
			}
			If ($Configuracion.ScheduledReboots.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tReinicios programados: " + $Configuracion.ScheduledReboots.Value + "\n"
			}
			If ($Configuracion.RebootCustomMessageText.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tTexto personalizado de advertencia de reinicio: " + $Configuracion.RebootCustomMessageText.Value + "\n"
			}
		}
		
		If (($Configuracion.MaximumServersOfflinePercent.State -ne "NotConfigured") -or ($Configuracion.HealthMonitoring.State -ne "NotConfigured"))
		{
			$Directiva.Configuracion += "Configuracin del servidor \ Supervisin del estado y recuperacin\n"
			If ($Configuracion.MaximumServersOfflinePercent.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tPorcentaje mximo de servidores con control de inicio de sesion: " + $Configuracion.MaximumServersOfflinePercent.Value + "\n"
			}
			If ($Configuracion.HealthMonitoringTests.State -ne "NotConfigured")
			{
				[xml]$xml = $Configuracion.HealthMonitoringTests.Value
				foreach ($test in $xml.HMRTests.Tests.Test)
				{
					$Directiva.Configuracion += "\tNombre:" + $test.name + "\n"
					$Directiva.Configuracion += "\tArchivo:" + $test.file + "\n"
					$Directiva.Configuracion += "\tArgumentos:" + $test.arguments + "\n"
					$Directiva.Configuracion += "\tIntervalo:" + $test.interval + "\n"
					$Directiva.Configuracion += "\tUmbral:" + $test.threshold + "\n"
					$Directiva.Configuracion += "\tTime Out:" + $test.timeout + "\n"
					$Directiva.Configuracion += "\tAccion de Recuperacion:" + $test.RecoveryAction + "\n\n"
				}
				
			}
			If ($Configuracion.HealthMonitoring.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tSupervision de estado: " + $Configuracion.HealthMonitoring.State + "\n"
			}
		}
		
		If (($Configuracion.IcaListenerPortNumber.State -ne "NotConfigured") -or ($Configuracion.IcaListenerTimeout.State -ne "NotConfigured"))
		{
			$Directiva.Configuracion += "ICA\n"
			If ($Configuracion.IcaListenerPortNumber.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tNmero de puerto de escucha ICA: " + $Configuracion.IcaListenerPortNumber.Value + "\n"
			}
			If ($Configuracion.IcaListenerTimeout.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tTiempo de espera de la conexin de escucha ICA: " + $Configuracion.IcaListenerTimeout.Value + "\n"
			}
		}
		
		If (($Configuracion.MultiStreamPolicy.State -ne "NotConfigured") -or ($Configuracion.MultiPortPolicy.State -ne "NotConfigured"))
		{
			$Directiva.Configuracion += "ICA \ Conexiones de multisecuencia\n"
			If ($Configuracion.MultiStreamPolicy.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tDirectiva de puertos mltiples: " + $Configuracion.MultiStreamPolicy.Value + "\n"
			}
			If ($Configuracion.MultiPortPolicy.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tMultisecuencia: " + $Configuracion.MultiPortPolicy.Value + "\n"
			}
		}
		
		If (($Configuracion.SessionReliabilityConnections.State -ne "NotConfigured") -or ($Configuracion.SessionReliabilityPort.State -ne "NotConfigured") -or ($Configuracion.SessionReliabilityTimeout.State -ne "NotConfigured"))
		{
			$Directiva.Configuracion += "ICA \ Fiabilidad de la sesin\n"
			If ($Configuracion.SessionReliabilityConnections.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tConexiones de fiabilidad de la sesion: " + $Configuracion.SessionReliabilityConnections.Value + "\n"
			}
			If ($Configuracion.SessionReliabilityPort.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tNmero de puerto para fiabilidad de la sesion: " + $Configuracion.SessionReliabilityPort.Value + "\n"
			}
			If ($Configuracion.SessionReliabilityTimeout.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tTiempo de espera de fiabilidad de la sesion: " + $Configuracion.SessionReliabilityTimeout.Value + "\n"
			}
		}
		
		If (($Configuracion.ImageCaching.State -ne "NotConfigured") -or ($Configuracion.QueueingAndTossing.State -ne "NotConfigured") -or ($Configuracion.DisplayMemoryLimit.State -ne "NotConfigured") -or ($Configuracion.DisplayDegradeUserNotification.State -ne "NotConfigured") -or ($Configuracion.DisplayDegradePreference.State -ne "NotConfigured") -or ($Configuracion.MaximumColorDepth.State -ne "NotConfigured") -or ($Configuracion.DynamicPreview.State -ne "NotConfigured"))
		{
			$Directiva.Configuracion += "ICA \ Grficos\n"
			If ($Configuracion.ImageCaching.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tCach de imgenes: " + $Configuracion.ImageCaching.Value + "\n"
			}
			If ($Configuracion.QueueingAndTossing.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tEn cola y descarte: " + $Configuracion.QueueingAndTossing.Value + "\n"
			}
			If ($Configuracion.DisplayMemoryLimit.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tLmite de memoria de presentacin: " + $Configuracion.DisplayMemoryLimit.Value + "\n"
			}
			If ($Configuracion.DisplayDegradeUserNotification.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tNotificar al usuario cuando se degrada la presentacin: " + $Configuracion.DisplayDegradeUserNotification.Value + "\n"
			}
			If ($Configuracion.DisplayDegradePreference.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tPreferencia de degradacin de presentacin: " + $Configuracion.DisplayDegradePreference.Value + "\n"
			}
			If ($Configuracion.MaximumColorDepth.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tProfundidad de color mxima permitida: " + $Configuracion.MaximumColorDepth.Value + "\n"
			}
			If ($Configuracion.DynamicPreview.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tVista previa de ventanas dinmicas: " + $Configuracion.DynamicPreview.Value + "\n"
			}
		}
		
		
		If ($Configuracion.PersistentCache.State -ne "NotConfigured")
		{
			$Directiva.Configuracion += "ICA \ Grficos \ Almacenamiento en cach\n"
			$Directiva.Configuracion += "\tUmbral de cach persistente: " + $Configuracion.PersistentCache.Value + "\n"
		}
		
		#$Directiva.Configuracion += "\tImpresin\n"
		#$Directiva.Configuracion += "Servidor de impresin universal\n"
		#If ($Configuracion.XX.State -ne "NotConfigured")
		#{
		#	$Directiva.Configuracion += "\t:" + $Configuracion.XX.Value + "\n"
		#}
		#If ($Configuracion.XX.State -ne "NotConfigured")
		#{
		#	$Directiva.Configuracion += "\t:" + $Configuracion.XX.Value + "\n"
		#}
		#If ($Configuracion.XX.State -ne "NotConfigured")
		#{
		#	$Directiva.Configuracion += "\t:" + $Configuracion.XX.Value + "\n"
		#}
		
		If (($Configuracion.IcaKeepAlives.State -ne "NotConfigured") -or ($Configuracion.IcaKeepAliveTimeout.State -ne "NotConfigured"))
		{
			$Directiva.Configuracion += "ICA \ Keep Alive\n"
			If ($Configuracion.IcaKeepAlives.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tICA Keep Alive: " + $Configuracion.IcaKeepAlives.Value + "\n"
			}
			If ($Configuracion.IcaKeepAliveTimeout.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tTiempo de espera de ICA Keep Alive: " + $Configuracion.IcaKeepAliveTimeout.Value + "\n"
			}
		}
			
		
		If ($Configuracion.IdleTimerInterval.State -ne "NotConfigured")
		{
			$Directiva.Configuracion += "ICA \ Lmites de servidor\n"
			$Directiva.Configuracion += "\tIntervalo de temporizador de sesin inactivo: " + $Configuracion.IdleTimerInterval.Value + "\n"
		}
		
		
		
		If (($Configuracion.MultimediaConferencing.State -ne "NotConfigured") -or ($Configuracion.MultimediaAcceleration.State -ne "NotConfigured") -or ($Configuracion.MultimediaAccelerationDefaultBufferSize.State -ne "NotConfigured") -or ($Configuracion.MultimediaAccelerationUseDefaultBufferSize.State -ne "NotConfigured"))
		{
			$Directiva.Configuracion += "ICA \ Multimedia\n"
			If ($Configuracion.MultimediaConferencing.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tConferencia Multimedia: " + $Configuracion.MultimediaConferencing.Value + "\n"
			}
			If ($Configuracion.MultimediaAcceleration.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tRedireccin de Windows Media: " + $Configuracion.MultimediaAcceleration.Value + "\n"
			}
			If ($Configuracion.MultimediaAccelerationDefaultBufferSize.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tTamao del bfer de redireccin de Windows Media: " + $Configuracion.MultimediaAccelerationDefaultBufferSize.Value + "\n"
			}
			If ($Configuracion.MultimediaAccelerationUseDefaultBufferSize.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tUso del tamao del bfer de redireccin de Windows Media: " + $Configuracion.MultimediaAccelerationUseDefaultBufferSize.Value + "\n"
			}
		}
		If (($Configuracion.AutoClientReconnect.State -ne "NotConfigured") -or ($Configuracion.AutoClientReconnectLogging.State -ne "NotConfigured"))
		{
			$Directiva.Configuracion += "ICA \ Reconexin automtica de clientes\n"
			If ($Configuracion.AutoClientReconnect.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tReconexin automtica de clientes: " + $Configuracion.AutoClientReconnect.Value + "\n"
			}
			If ($Configuracion.AutoClientReconnectLogging.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tRegistro de reconexin automtica de clientes: " + $Configuracion.AutoClientReconnectLogging.Value + "\n"
			}
		}
			
		
		If ($Configuracion.Shadowing.State -ne "NotConfigured")
		{
			$Directiva.Configuracion += "ICA \ Remedo\n"
			$Directiva.Configuracion += "\tRemedo: " + $Configuracion.Shadowing.Value + "\n"
		}
		
		
		If ($Configuracion.PromptForPassword.State -ne "NotConfigured")
		{
			$Directiva.Configuracion += "ICA \ Seguridad\n"
			$Directiva.Configuracion += "\tPedir Contrasea: " + $Configuracion.PromptForPassword.Value + "\n"
		}
		
		If (($Configuracion.IcaRoundTripCalculation.State -ne "NotConfigured") -or ($Configuracion.IcaRoundTripCalculationWhenIdle.State -ne "NotConfigured") -or ($Configuracion.IcaRoundTripCalculationInterval.State -ne "NotConfigured"))
		{
			$Directiva.Configuracion += "ICA \ Supervisin de usaurio final\n"
			If ($Configuracion.IcaRoundTripCalculation.State -ne "NotConfigured: ")
			{
				$Directiva.Configuracion += "\tClculo del tiempo de retorno ICA" + $Configuracion.IcaRoundTripCalculation.Value + "\n"
			}
			If ($Configuracion.IcaRoundTripCalculationWhenIdle.State -ne "NotConfigured: ")
			{
				$Directiva.Configuracion += "\tClculo del tiempo de retorno ICA para conexiones inactivas: " + $Configuracion.IcaRoundTripCalculationWhenIdle.Value + "\n"
			}
			If ($Configuracion.IcaRoundTripCalculationInterval.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tIntervalo de clculo del tiempo de retorno ICA: " + $Configuracion.IcaRoundTripCalculationInterval.Value + "\n"
			}
		}
		
		If (($Configuracion.EnhancedCompatibility.State -ne "NotConfigured") -or ($Configuracion.FilterAdapterAddresses.State -ne "NotConfigured") -or ($Configuracion.VirtualLoopbackPrograms.State -ne "NotConfigured") -or ($Configuracion.EnhancedCompatibilityPrograms.State -ne "NotConfigured") -or ($Configuracion.FilterAdapterAddressesPrograms.State -ne "NotConfigured") -or ($Configuracion.VirtualLoopbackSupport.State -ne "NotConfigured"))
		{
			$Directiva.Configuracion += "IP virtual\n"
			If ($Configuracion.EnhancedCompatibility.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tCompatibilidad mejorada de IP virtual: " + $Configuracion.EnhancedCompatibility.Value + "\n"
			}
			If ($Configuracion.FilterAdapterAddresses.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tFiltrado de direcciones de adaptador de IP virtual: " + $Configuracion.FilterAdapterAddresses.Value + "\n"
			}
			If ($Configuracion.VirtualLoopbackPrograms.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tLista de programas para bucle invertido de IP virtual: " + $Configuracion.VirtualLoopbackPrograms.Value + "\n"
			}
			If ($Configuracion.EnhancedCompatibilityPrograms.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tLista de programas para compatibilidad con IP virtual: " + $Configuracion.EnhancedCompatibilityPrograms.Value + "\n"
			}
			If ($Configuracion.FilterAdapterAddressesPrograms.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tLista de programas para filtrado de direcciones de adaptador de IP virtual: " + $Configuracion.FilterAdapterAddressesPrograms.Value + "\n"
			}
			If ($Configuracion.VirtualLoopbackSupport.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tRespaldo para bucle invertido de IP virtual: " + $Configuracion.VirtualLoopbackSupport.Value + "\n"
			}
		}
		
		If (($Configuracion.TrustXmlRequests.State -ne "NotConfigured") -or ($Configuracion.XmlServicePort.State -ne "NotConfigured"))
		{
			$Directiva.Configuracion += "XML Service\n"
			If ($Configuracion.TrustXmlRequests.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tConfiar en solicitudes XML: " + $Configuracion.TrustXmlRequests.Value + "\n"
			}
			If ($Configuracion.XmlServicePort.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tPuerto de XML Service: " + $Configuracion.XmlServicePort.Value + "\n"
			}
		}
	}
	
	If ($Configuracion.Type -eq "User")
	{
		#Directivas de usuario
		#ICA
		If (($Configuracion.NonPublishedProgramLaunching.State -ne "NotConfigured") -or ($Configuracion.DesktopLaunchForNonAdmins.State -ne "NotConfigured") -or ($Configuracion.ClipboardRedirection.State -ne "NotConfigured"))
		{
			$Directiva.Configuracion += "ICA\n"
			If ($Configuracion.NonPublishedProgramLaunching.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tICA \ Inicio de programas no publicados durante la conexin del cliente: " + $Configuracion.NonPublishedProgramLaunching.State + "\n"
			}
			If ($Configuracion.DesktopLaunchForNonAdmins.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tICA \ Inicios de escritorio: " + $Configuracion.DesktopLaunchForNonAdmins.State + "\n"
			}
			If ($Configuracion.ClipboardRedirection.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tICA \ Redireccin del portapapeles del cliente: " + $Configuracion.ClipboardRedirection.State + "\n"
			}
		}
		
		#ICA\Ancho de Banda
		If (($Configuracion.HDXMultimediaBandwidthPercent.State -ne "NotConfigured") -or ($Configuracion.USBBandwidthLimit.State -ne "NotConfigured") -or ($Configuracion.AudioBandwidthLimit.State -ne "NotConfigured") -or ($Configuracion.ClipboardBandwidthLimit.State -ne "NotConfigured") -or ($Configuracion.OverallBandwidthLimit.State -ne "NotConfigured") -or ($Configuracion.ComPortBandwidthLimit.State -ne "NotConfigured") -or ($Configuracion.FileRedirectionBandwidthLimit.State -ne "NotConfigured") -or ($Configuracion.TwainBandwidthLimit.State -ne "NotConfigured") -or ($Configuracion.PrinterBandwidthLimit.State -ne "NotConfigured") -or ($Configuracion.LptBandwidthLimit.State -ne "NotConfigured") -or ($Configuracion.HDXMultimediaBandwidthLimit.State -ne "NotConfigured") -or ($Configuracion.FileRedirectionBandwidthPercent.State -ne "NotConfigured") -or ($Configuracion.TwainBandwidthPercent.State -ne "NotConfigured") -or ($Configuracion.USBBandwidthPercent.State -ne "NotConfigured") -or ($Configuracion.PrinterBandwidthPercent.State -ne "NotConfigured") -or ($Configuracion.ComPortBandwidthPercent.State -ne "NotConfigured") -or ($Configuracion.LptBandwidthLimitPercent.State -ne "NotConfigured") -or ($Configuracion.AudioBandwidthPercent.State -ne "NotConfigured") -or ($Configuracion.ClipboardBandwidthPercent.State -ne "NotConfigured"))
		{
			$Directiva.Configuracion += "ICA \ Ancho de Banda\n"
			If ($Configuracion.HDXMultimediaBandwidthPercent.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tLmite de ancho de banda de aceleracin multimedia HDX MediaStream: " + $Configuracion.HDXMultimediaBandwidthPercent.Value + "\n"
			}
			If ($Configuracion.USBBandwidthLimit.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tLmite de ancho de banda de redireccin de dispositivos USB del cliente: " + $Configuracion.USBBandwidthLimit.Value + "\n"
			}
			If ($Configuracion.AudioBandwidthLimit.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tLmite de ancho de banda de redireccin de sonido: " + $Configuracion.AudioBandwidthLimit.Value + "\n"
			}
			If ($Configuracion.ClipboardBandwidthLimit.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tLmite de ancho de banda de redireccin del portapapeles: " + $Configuracion.ClipboardBandwidthLimit.Value + "\n"
			}
			If ($Configuracion.OverallBandwidthLimit.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tLmite de ancho de banda global de la sesin " + $Configuracion.OverallBandwidthLimit.Value + "\n"
			}
			If ($Configuracion.ComPortBandwidthLimit.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tLmite de ancho de banda para la redireccin de puertos COM: " + $Configuracion.ComPortBandwidthLimit.Value + "\n"
			}
			If ($Configuracion.FileRedirectionBandwidthLimit.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tLmite de ancho de banda para redireccin de archivos: " + $Configuracion.FileRedirectionBandwidthLimit.Value + "\n"
			}
			If ($Configuracion.TwainBandwidthLimit.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tLmite de ancho de banda para redireccin de dispositivos TWAIN: " + $Configuracion.TwainBandwidthLimit.Value + "\n"
			}
			If ($Configuracion.PrinterBandwidthLimit.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tLmite de ancho de banda para redireccin de impresoras: " + $Configuracion.PrinterBandwidthLimit.Value + "\n"
			}
			If ($Configuracion.LptBandwidthLimit.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tLmite de ancho de banda para redireccin de puertos LPT: " + $Configuracion.LptBandwidthLimit.Value + "\n"
			}	
			If ($Configuracion.HDXMultimediaBandwidthLimit.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tPorcentaje lmite de ancho de banda de aceleracin multimedia HDX MediaStream: " + $Configuracion.HDXMultimediaBandwidthLimit.Value + "\n"
			}
			If ($Configuracion.FileRedirectionBandwidthPercent.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tPorcentaje lmite de ancho de banda de redireccin de archivos: " + $Configuracion.FileRedirectionBandwidthPercent.Value + "\n"
			}
			If ($Configuracion.TwainBandwidthPercent.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tPorcentaje lmite de ancho de banda de redireccin de dispositivos TWAIN: " + $Configuracion.TwainBandwidthPercent.Value + "\n"
			}
			If ($Configuracion.USBBandwidthPercent.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tPorcentaje lmite de ancho de banda de redireccin de dispositivos USB del cliente: " + $Configuracion.USBBandwidthPercent.Value + "\n"
			}
			If ($Configuracion.PrinterBandwidthPercent.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tPorcentaje lmite de ancho de banda de redireccin de impresoras: " + $Configuracion.PrinterBandwidthPercent.Value + "\n"
			}
			If ($Configuracion.ComPortBandwidthPercent.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tPorcentaje lmite de ancho de banda de redireccin de puertos COM: " + $Configuracion.ComPortBandwidthPercent.Value + "\n"
			}
			If ($Configuracion.LptBandwidthLimitPercent.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tPorcentaje lmite de ancho de banda de redireccin de puertos LPT: " + $Configuracion.LptBandwidthLimitPercent.Value + "\n"
			}
			If ($Configuracion.AudioBandwidthPercent.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tPorcentaje lmite de ancho de banda de redireccin de sonido: " + $Configuracion.AudioBandwidthPercent.Value + "\n"
			}
			If ($Configuracion.ClipboardBandwidthPercent.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tPorcentaje lmite de ancho de banda de redireccin de portapapeles: " + $Configuracion.ClipboardBandwidthPercent.Value + "\n"
			}
		}
		
		#ICA\Conexiones de multisecuencia
		If ($Configuracion.MultiStream.State -ne "NotConfigured")
		{
			$Directiva.Configuracion += "ICA \ Conexiones de multisecuencia\n"
			$Directiva.Configuracion += "\tMultisecuencia: " + $Configuracion.MultiStream.State + "\n"
		}		
		
		#ICA\COntrol de zona horaria
		If (($Configuracion.LocalTimeEstimation.State -ne "NotConfigured") -or ($Configuracion.SessionTimeZone.State -ne "NotConfigured"))
		{
			$Directiva.Configuracion += "ICA \ Control de zona horaria\n"
			If ($Configuracion.LocalTimeEstimation.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tCalcular hora local para clientes antiguos: " + $Configuracion.LocalTimeEstimation.State + "\n"
			}	
			
			If ($Configuracion.SessionTimeZone.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tUsar la hora local del cliente: " + $Configuracion.SessionTimeZone.Value + "\n"
			}	
		}

		#ICA\Dispositivos TWAIN
		If (($Configuracion.TwainCompressionLevel.State -ne "NotConfigured") -or ($Configuracion.TwainRedirection.State -ne "NotConfigured"))
		{
			$Directiva.Configuracion += "ICA \ Dispositivos TWAIN\n"
			If ($Configuracion.TwainCompressionLevel.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tNivel de compresin TWAIN: " + $Configuracion.TwainCompressionLevel.Value + "\n"
			}	
			If ($Configuracion.TwainRedirection.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tRedireccin de dispositovs TWAIN del cliente: " + $Configuracion.TwainRedirection.State + "\n"
			}
		}
		
		#ICA\Dispositivos USB
		If (($Configuracion.UsbDeviceRedirection.State -ne "NotConfigured") -or ($Configuracion.UsbDeviceRedirectionRules.State -ne "NotConfigured") -or ($Configuracion.UsbPlugAndPlayRedirection.State -ne "NotConfigured"))
		{
			$Directiva.Configuracion += "ICA \ Dispositivos USB\n"
			If ($Configuracion.UsbDeviceRedirection.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tRedireccin del dispositivos USB del cliente: " + $Configuracion.UsbDeviceRedirection.State + "\n"
			}
			If ($Configuracion.UsbDeviceRedirectionRules.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tReglas de redireccin de dispositivos USB del cliente: " + $Configuracion.UsbDeviceRedirectionRules.State + "\n"
			}
			If ($Configuracion.UsbPlugAndPlayRedirection.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tRedireccin de dispositivos USB plug and play del cliente: " + $Configuracion.UsbPlugAndPlayRedirection.Value + "\n"
			}
		}
		
		#ICA\Entrega de Adobe Flash
		If ($Configuracion.AllowSpeedFlash.State -ne "NotConfigured")
		{
			$Directiva.Configuracion += "ICA \ Entrega de Adobe Flash \ Optimizaciones del lado del servidor\n"
			$Directiva.Configuracion += "\tAjuste de calidad de Flash: " + $Configuracion.AllowSpeedFlash.Value + "\n"
		}
		
		If (($Configuracion.FlashServerSideContentFetchingWhitelist.State -ne "NotConfigured") -or ($Configuracion.FlashAcceleration.State -ne "NotConfigured") -or ($Configuracion.FlashBackwardsCompatibility.State -ne "NotConfigured") -or ($Configuracion.FlashDefaultBehavior.State -ne "NotConfigured") -or ($Configuracion.FlashUrlColorList.State -ne "NotConfigured") -or ($Configuracion.FlashUrlCompatibilityList.State -ne "NotConfigured") -or ($Configuracion.FlashEventLogging.State -ne "NotConfigured") -or ($Configuracion.FlashIntelligentFallback.State -ne "NotConfigured") -or ($Configuracion.FlashLatencyThreshold.State -ne "NotConfigured"))
		{
			$Directiva.Configuracion += "ICA \ Entrega de Adobe Flash \ Redireccin de Flash\n"
			If ($Configuracion.FlashServerSideContentFetchingWhitelist.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tLista de URL para obtener contenido Flash del lado del servidor: " + $Configuracion.FlashServerSideContentFetchingWhitelist.Value + "\n"
			}
			If ($Configuracion.FlashAcceleration.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tAceleracin de Flash: " + $Configuracion.FlashAcceleration.State + "\n"
			}
			If ($Configuracion.FlashBackwardsCompatibility.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tCompatibilidad con versiones anteriores de Flash: " + $Configuracion.FlashBackwardsCompatibility.State + "\n"
			}
			If ($Configuracion.FlashDefaultBehavior.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tComportamiento predeterminado de Flash: " + $Configuracion.FlashDefaultBehavior.Value + "\n"
			}	
			If ($Configuracion.FlashUrlColorList.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tLista de colores de fondo de Flash: " + $Configuracion.FlashUrlColorList.Value + "\n"
			}
			If ($Configuracion.FlashUrlCompatibilityList.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tLista de compatibilidad de URL de Flash: " + $Configuracion.FlashUrlCompatibilityList.Value + "\n"
			}
			If ($Configuracion.FlashEventLogging.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tRegistro de sucesos de Flash: " + $Configuracion.FlashEventLogging.State + "\n"
			}
			If ($Configuracion.FlashIntelligentFallback.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tRetorno Inteligente de Flash: " + $Configuracion.FlashIntelligentFallback.State + "\n"
			}
			If ($Configuracion.FlashLatencyThreshold.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tUmbral de latencia de Flash: " + $Configuracion.FlashLatencyThreshold.Value + "\n"
			}
		}
			
		#ICA\Impresin
		If (($Configuracion.WaitForPrintersToBeCreated.State -ne "NotConfigured") -or ($Configuracion.DefaultClientPrinter.State -ne "NotConfigured") -or ($Configuracion.SessionPrinters.State -ne "NotConfigured") -or ($Configuracion.AutoCreationEventLogPreference.State -ne "NotConfigured") -or ($Configuracion.ClientPrinterRedirection.State -ne "NotConfigured"))
		{
			$Directiva.Configuracion += "ICA \ Impresin\n"
			If ($Configuracion.WaitForPrintersToBeCreated.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tEsperar a que se creen las impresoras (escritorio): " + $Configuracion.WaitForPrintersToBeCreated.State + "\n"
			}
			If ($Configuracion.DefaultClientPrinter.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tImpresora predeterminada: " + $Configuracion.DefaultClientPrinter.Value + "\n"
			}
			If ($Configuracion.SessionPrinters.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tImpresoras de la sesin: " + $Configuracion.SessionPrinters.Value + "\n"
			}
			If ($Configuracion.AutoCreationEventLogPreference.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tPreferencia de registro de sucesos de creacin automtica de impresoras: " + $Configuracion.AutoCreationEventLogPreference.Value + "\n"
			}
			If ($Configuracion.ClientPrinterRedirection.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tRedireccin de impresoras del cliente: " + $Configuracion.ClientPrinterRedirection.State + "\n"
			}
		}
		
		If (($Configuracion.InboxDriverAutoInstallation.State -ne "NotConfigured") -or ($Configuracion.UniversalDriverPriority.State -ne "NotConfigured") -or ($Configuracion.UniversalPrintDriverUsage.State -ne "NotConfigured"))
		{	
			$Directiva.Configuracion += "ICA \ Impresin \ Controladores\n"
			If ($Configuracion.InboxDriverAutoInstallation.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tInstalacin automtica de controladores de impresora: " + $Configuracion.InboxDriverAutoInstallation.State + "\n"
			}
			If ($Configuracion.UniversalDriverPriority.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tPreferencia de controlador universal: " + $Configuracion.UniversalDriverPriority.Value + "\n"
			}
			If ($Configuracion.UniversalPrintDriverUsage.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tUso de controladores de impresin universal: " + $Configuracion.UniversalPrintDriverUsage.Value + "\n"
			}
		}
		
		If (($Configuracion.PrinterDriverMappings.State -ne "NotConfigured") -or ($Configuracion.DirectConnectionsToPrintServers.State -ne "NotConfigured") -or ($Configuracion.ClientPrinterAutoCreation.State -ne "NotConfigured") -or ($Configuracion.GenericUniversalPrinterAutoCreation.State -ne "NotConfigured") -or ($Configuracion.RetainedAndRestoredClientPrinters.State -ne "NotConfigured") -or ($Configuracion.ClientPrinterNames.State -ne "NotConfigured") -or ($Configuracion.PrinterPropertiesRetention.State -ne "NotConfigured"))
		{
			$Directiva.Configuracion += "ICA \ Impresin \ Impresoras del cliente\n"
			If ($Configuracion.PrinterDriverMappings.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tAsignacin y compatibilidad de controladores de impresora: " + $Configuracion.PrinterDriverMappings.Value + "\n"
			}
			If ($Configuracion.DirectConnectionsToPrintServers.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tConexiones directas con servidores de impresin: " + $Configuracion.DirectConnectionsToPrintServers.State + "\n"
			}
			If ($Configuracion.ClientPrinterAutoCreation.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tCrear automticamente las impresoras del cliente: " + $Configuracion.ClientPrinterAutoCreation.Value + "\n"
			}
			If ($Configuracion.GenericUniversalPrinterAutoCreation.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tCrear automticamente una impresora universal genrica: " + $Configuracion.GenericUniversalPrinterAutoCreation.State + "\n"
			}
			If ($Configuracion.RetainedAndRestoredClientPrinters.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tImpresoras del cliente retendias o restauradas: " + $Configuracion.RetainedAndRestoredClientPrinters.State + "\n"
			}
			If ($Configuracion.ClientPrinterNames.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tNombres de impresora del cliente: " + $Configuracion.ClientPrinterNames.Value + "\n"
			}
			If ($Configuracion.PrinterPropertiesRetention.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "Retencin de las propiedades de impresoras\t: " + $Configuracion.PrinterPropertiesRetention.Value + "\n"
			}		
		}
			
		If (($Configuracion.DPILimit.State -ne "NotConfigured") -or ($Configuracion.ImageCompressionLimit.State -ne "NotConfigured") -or ($Configuracion.EMFProcessingMode.State -ne "NotConfigured") -or ($Configuracion.UniversalPrintingPreviewPreference.State -ne "NotConfigured") -or ($Configuracion.UPDCompressionDefaults.State -ne "NotConfigured"))
		{
			$Directiva.Configuracion += "ICA \ Impresin \ Impresin universal\n"
			If ($Configuracion.DPILimit.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tLmite de calidad de la impresin universal: " + $Configuracion.DPILimit.Value + "\n"
			}
			If ($Configuracion.ImageCompressionLimit.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\t: " + $Configuracion.ImageCompressionLimit.Value + "\n"
			}
			If ($Configuracion.EMFProcessingMode.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tModo de procesamiento EMF de la impresin universal: " + $Configuracion.EMFProcessingMode.Value + "\n"
			}
			If ($Configuracion.UniversalPrintingPreviewPreference.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tPreferencia de vista previa en impresin universal: " + $Configuracion.UniversalPrintingPreviewPreference.Value + "\n"
			}
			If ($Configuracion.UPDCompressionDefaults.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tValores predeterminados de la impresin universal: " + $Configuracion.UPDCompressionDefaults.Value + "\n"
			}
		}
			
		#ICA\Interfaz de usuario de escritorio
		If (($Configuracion.MenuAnimation.State -ne "NotConfigured") -or ($Configuracion.DesktopWallpaper.State -ne "NotConfigured") -or ($Configuracion.WindowContentsVisibleWhileDragging.State -ne "NotConfigured"))
		{
			$Directiva.Configuracion += "ICA \ Interfaz de usuario de escritorio\n"
			If ($Configuracion.MenuAnimation.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tAnimacin de mens: " + $Configuracion.MenuAnimation.State + "\n"
			}
			If ($Configuracion.DesktopWallpaper.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tTapiz del escritorio: " + $Configuracion.DesktopWallpaper.State + "\n"
			}
			If ($Configuracion.WindowContentsVisibleWhileDragging.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "Ver contenido de las ventanas al arrastrar\t: " + $Configuracion.WindowContentsVisibleWhileDragging.State + "\n"
			}
		}
			
		#ICA\Lmites de sesin
		If (($Configuracion.SessionConnectionTimerInterval.State -ne "NotConfigured") -or ($Configuracion.PrelaunchDisconnectTimerInterval.State -ne "NotConfigured") -or ($Configuracion.PrelaunchTerminateTimerInterval.State -ne "NotConfigured") -or ($Configuracion.PrelaunchTerminateTimerInterval.State -ne "NotConfigured") -or ($Configuracion.LingerTerminateTimerInterval.State -ne "NotConfigured") -or ($Configuracion.SessionDisconnectTimerInterval.State -ne "NotConfigured") -or ($Configuracion.SessionIdleTimerInterval.State -ne "NotConfigured") -or ($Configuracion.ConcurrentLogOnLimit.State -ne "NotConfigured") -or ($Configuracion.SessionConnectionTimer.State -ne "NotConfigured") -or ($Configuracion.SessionDisconnectTimer.State -ne "NotConfigured") -or ($Configuracion.SessionIdleTimer.State -ne "NotConfigured"))
		{
			$Directiva.Configuracion += "ICA \ Lmites de sesin\n"
			If ($Configuracion.SessionConnectionTimerInterval.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tIntervalo de temporizador de conexin de sesiones: " + $Configuracion.SessionConnectionTimerInterval.Value + "\n"
			}
			If ($Configuracion.PrelaunchDisconnectTimerInterval.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tIntervalo de temporizador de desconexin de preinicio: " + $Configuracion.PrelaunchDisconnectTimerInterval.Value + "\n"
			}
			If ($Configuracion.PrelaunchTerminateTimerInterval.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tIntervalo de temporizador de desconexin de sesin persistente: " + $Configuracion.LingerDisconnectTimerInterval.Value + "\n"
			}
			If ($Configuracion.PrelaunchTerminateTimerInterval.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tIntervalo de temporizador de fin de preinicio: " + $Configuracion.PrelaunchTerminateTimerInterval.Value + "\n"
			}
			If ($Configuracion.LingerTerminateTimerInterval.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tIntervalo de temporizador de fin de sesin persistente: " + $Configuracion.LingerTerminateTimerInterval.Value + "\n"
			}
			If ($Configuracion.SessionDisconnectTimerInterval.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tIntervalo de temporizador de sesiones desconectadas: " + $Configuracion.SessionDisconnectTimerInterval.Value + "\n"
			}
			If ($Configuracion.SessionIdleTimerInterval.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tIntervalo de temporizador de sesiones inactivas: " + $Configuracion.SessionIdleTimerInterval.Value + "\n"
			}
			If ($Configuracion.ConcurrentLogOnLimit.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tLmite de sesiones simultneas: " + $Configuracion.ConcurrentLogOnLimit.Value + "\n"
			}
			If ($Configuracion.SessionConnectionTimer.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tTemporizador de conexin de sesin: " + $Configuracion.SessionConnectionTimer.State + "\n"
			}
			If ($Configuracion.SessionDisconnectTimer.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tTemporizador de sesin desconectada: " + $Configuracion.SessionDisconnectTimer.State + "\n"
			}
			If ($Configuracion.SessionIdleTimer.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tTemporizador de sesin inactiva: " + $Configuracion.SessionIdleTimer.State + "\n"
			}
		}
		
		#ICA\Presentacin visual
		If ($Configuracion.FramesPerSecond.State -ne "NotConfigured")
		{
			$Directiva.Configuracion += "ICA \ Presentacin Visual\n"
			$Directiva.Configuracion += "\tMximo de cuadros por segundo: " + $Configuracion.FramesPerSecond.Value + "\n"
		}
		
		If (($Configuracion.ProgressiveCompressionLevel.State -ne "NotConfigured") -or ($Configuracion.ProgressiveCompressionThreshold.State -ne "NotConfigured"))
		{
			$Directiva.Configuracion += "ICA \ Presentacin Visual \ Imgenes en movimiento\n"
			If ($Configuracion.ProgressiveCompressionLevel.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tNivel de compresin progresiva: " + $Configuracion.ProgressiveCompressionLevel.Value + "\n"
			}
			If ($Configuracion.ProgressiveCompressionThreshold.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tValor de umbral de compresin progresiva: " + $Configuracion.ProgressiveCompressionThreshold.Value + "\n"
			}
		}
		
		If (($Configuracion.ExtraColorCompression.State -ne "NotConfigured") -or ($Configuracion.ProgressiveHeavyweightCompression.State -ne "NotConfigured") -or ($Configuracion.LossyCompressionLevel.State -ne "NotConfigured") -or ($Configuracion.ExtraColorCompressionThreshold.State -ne "NotConfigured") -or ($Configuracion.LossyCompressionThreshold.State -ne "NotConfigured"))
		{
			$Directiva.Configuracion += "ICA \ Presentacin Visual \ Imgines fijas\n"
			If ($Configuracion.ExtraColorCompression.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tCompresin de color adicional: " + $Configuracion.ExtraColorCompression.State + "\n"
			}
			If ($Configuracion.ProgressiveHeavyweightCompression.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tCompresin intensa: " + $Configuracion.ProgressiveHeavyweightCompression.State + "\n"
			}
			If ($Configuracion.LossyCompressionLevel.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tNivel de compresin con prdida: " + $Configuracion.LossyCompressionLevel.Value + "\n"
			}
			If ($Configuracion.ExtraColorCompressionThreshold.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tUmbral de compresn de color adicional: " + $Configuracion.ExtraColorCompressionThreshold.Value + "\n"
			}
			If ($Configuracion.LossyCompressionThreshold.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tValor de umbral de compresin con prdida: " + $Configuracion.LossyCompressionThreshold.Value + "\n"
			}
		}
		
		#ICA\Redireccin de archivos
		If (($Configuracion.ReadOnlyMappedDrive.State -ne "NotConfigured") -or ($Configuracion.AutoConnectDrives.State -ne "NotConfigured") -or ($Configuracion.SpecialFolderRedirection.State -ne "NotConfigured") -or ($Configuracion.ClientDriveRedirection.State -ne "NotConfigured") -or ($Configuracion.HostToClientRedirection.State -ne "NotConfigured") -or ($Configuracion.ClientFloppyDrives.State -ne "NotConfigured") -or ($Configuracion.ClientNetworkDrives.State -ne "NotConfigured") -or ($Configuracion.ClientRemoveableDrives.State -ne "NotConfigured") -or ($Configuracion.ClientFixedDrives.State -ne "NotConfigured") -or ($Configuracion.ClientOpticalDrives.State -ne "NotConfigured") -or ($Configuracion.AsynchronousWrites.State -ne "NotConfigured"))
		{
			$Directiva.Configuracion += "ICA \ Redireccin de archivos\n"
			If ($Configuracion.ReadOnlyMappedDrive.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tAcceso de lectura solamente a unidades del cliente: " + $Configuracion.ReadOnlyMappedDrive.State + "\n"
			}
			If ($Configuracion.AutoConnectDrives.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tConectar automticamente las unidades del cliente: " + $Configuracion.AutoConnectDrives.State + "\n"
			}
			If ($Configuracion.SpecialFolderRedirection.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tRedireccin de carpetas especiales: " + $Configuracion.SpecialFolderRedirection.State + "\n"
			}
			If ($Configuracion.ClientDriveRedirection.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tRedireccin de unidades del cliente: " + $Configuracion.ClientDriveRedirection.State + "\n"
			}
			If ($Configuracion.HostToClientRedirection.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tRedireccin del host al cliente: " + $Configuracion.HostToClientRedirection.State + "\n"
			}
			If ($Configuracion.ClientFloppyDrives.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tUnidades de disco flexible del cliente: " + $Configuracion.ClientFloppyDrives.State + "\n"
			}
			If ($Configuracion.ClientNetworkDrives.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tUnidades de red del cliente: " + $Configuracion.ClientNetworkDrives.State + "\n"
			}
			If ($Configuracion.ClientRemoveableDrives.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tUnidades extrables del cliente: " + $Configuracion.ClientRemoveableDrives.State + "\n"
			}
			If ($Configuracion.ClientFixedDrives.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tUnidades fijas del cliente: " + $Configuracion.ClientFixedDrives.State + "\n"
			}
			If ($Configuracion.ClientOpticalDrives.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tUnidades pticas del cliente: " + $Configuracion.ClientOpticalDrives.State + "\n"
			}
			If ($Configuracion.AsynchronousWrites.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tUsar escrituras asncronas: " + $Configuracion.AsynchronousWrites.State + "\n"
			}
		}
		
		#ICA\Redireccin de puertos
		If (($Configuracion.ClientComPortsAutoConnection.State -ne "NotConfigured") -or ($Configuracion.ClientLptPortsAutoConnection.State -ne "NotConfigured") -or ($Configuracion.ClientComPortRedirection.State -ne "NotConfigured") -or ($Configuracion.ClientLptPortRedirection.State -ne "NotConfigured"))
		{
			If ($Configuracion.ClientComPortsAutoConnection.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tConectar automticamente puertos COM del cliente: " + $Configuracion.ClientComPortsAutoConnection.State + "\n"
			}
			If ($Configuracion.ClientLptPortsAutoConnection.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tConectar automticamente puertos LPT del cliente: " + $Configuracion.ClientLptPortsAutoConnection.State + "\n"
			}
			If ($Configuracion.ClientComPortRedirection.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tRedireccin de puertos COM del cliente: " + $Configuracion.ClientComPortRedirection.State + "\n"
			}
			If ($Configuracion.ClientLptPortRedirection.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tRedireccin de puertos LPT del cliente: " + $Configuracion.ClientLptPortRedirection.State + "\n"
			}
		}
		
		#ICA\Remedo
		If (($Configuracion.ShadowInput.State -ne "NotConfigured") -or ($Configuracion.ShadowUserNotification.State -ne "NotConfigured") -or ($Configuracion.ShadowLogging.State -ne "NotConfigured") -or ($Configuracion.ShadowDenyList.State -ne "NotConfigured") -or ($Configuracion.ShadowAllowList.State -ne "NotConfigured"))
		{
			If ($Configuracion.ShadowInput.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tEntradas de conexiones de remedo: " + $Configuracion.ShadowInput.State + "\n"
			}
			If ($Configuracion.ShadowUserNotification.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tNotificar al usuario sobre conexiones de remedo pendientes: " + $Configuracion.ShadowUserNotification.State + "\n"
			}
			If ($Configuracion.ShadowLogging.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tRegistrar intentos de remedo: " + $Configuracion.ShadowLogging.State + "\n"
			}
			If ($Configuracion.ShadowDenyList.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tUsuarios que no pueden remedar a otros usuarios: " + $Configuracion.ShadowDenyList.Value + "\n"
			}
			If ($Configuracion.ShadowAllowList.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tUsuarios que pueden remedar a otros usuarios: " + $Configuracion.ShadowAllowList.Value + "\n"
			}
		}
			
		#ICA\Seguridad
		If ($Configuracion.MinimumEncryptionLevel.State -ne "NotConfigured")
		{
			$Directiva.Configuracion += "ICA\Seguridad\n"
			$Directiva.Configuracion += "\tNivel de cifrado mnimo de SecureICA: " + $Configuracion.MinimumEncryptionLevel.Value + "\n"
		}

		#ICA\Sensores del cliente
		
		#ICA\Sonido
		If (($Configuracion.AudioQuality.State -ne "NotConfigured") -or ($Configuracion.MicrophoneRedirection.State -ne "NotConfigured") -or ($Configuracion.ClientAudioRedirection.State -ne "NotConfigured") -or ($Configuracion.AudioPlugNPlay.State -ne "NotConfigured"))
		{
			If ($Configuracion.AudioQuality.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tCalidad de sonido: " + $Configuracion.AudioQuality.Value + "\n"
			}
			If ($Configuracion.MicrophoneRedirection.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tRedireccin de micrfonos del cliente: " + $Configuracion.MicrophoneRedirection.State + "\n"
			}
			If ($Configuracion.ClientAudioRedirection.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tRedireccin de sonido del cliente: " + $Configuracion.ClientAudioRedirection.State + "\n"
			}
			If ($Configuracion.AudioPlugNPlay.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tSonido plug and play: " + $Configuracion.AudioPlugNPlay.State + "\n"
			}
		}
			
		#Parametros de sesin del servidor
		If (($Configuracion.SingleSignOnCentralStore.State -ne "NotConfigured") -or ($Configuracion.SessionImportance.State -ne "NotConfigured") -or ($Configuracion.SingleSignOn.State -ne "NotConfigured"))
		{
			If ($Configuracion.SingleSignOnCentralStore.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tAlmacn central de Single Sign-On: " + $Configuracion.SingleSignOnCentralStore.Value + "\n"
			}
			If ($Configuracion.SessionImportance.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tImportancia de la sesin: " + $Configuracion.SessionImportance.Value + "\n"
			}
			If ($Configuracion.SingleSignOn.State -ne "NotConfigured")
			{
				$Directiva.Configuracion += "\tSingle Sign-On: " + $Configuracion.SingleSignOn.State + "\n"
			}
		}
		
		
		
		
	}
		
	$DirectivasContenido += $Directiva
}
Remove-PSDrive CitrixGPO

####Fin Directivas
#########################################
#Registro de Configuracion

$RegConfiguracion = Get-XAConfigurationLog -Computername $Servidor_DC 
$RegConfiguracionContenido = @()
If ($RegConfiguracion.LoggingEnabled)
{
	$Registro = "" | Select-Object Habilitado, Desconectado, Limpiar, Tipo, Autenticacion, Usuario, Servidor, BBDD
	#Registro de Configuracin habilitado
	$Registro.Habilitado = $RegConfiguracion.LoggingEnabled
	$Registro.Desconectado = $RegConfiguracion.ChangesWhileDisconnectedAllowed
	$Registro.Limpiar = $RegConfiguracion.CredentialsOnClearLogRequired
	
	$Registro.Tipo = $RegConfiguracion.DatabaseType
	$Registro.Autenticacion = $RegConfiguracion.AuthenticationMode
	$Registro.Usuario = $RegConfiguracion.UserName
	$Conexion=$RegConfiguracion.ConnectionString.Split(";")
	$Servidor=$Conexion[0].Split("=")
	$Registro.Servidor=$Servidor[1]
	$BBDD=$Conexion[1].Split("=")
	$Registro.BBDD=$BBDD[1]
		
	$RegConfiguracionContenido += $Registro
}
Else
{
	#Registro de configuracion deshabilitado
}

#########################################

#########################################
#Informacin general de la granja
$Granja=Get-XAFarm -Computername $Servidor_DC 
$GranjaContenido = @()
$GranjaInformacion = "" | Select-Object Nombre, Version, NumeroServidores, NumeroAplicaciones

$GranjaInformacion.Nombre = $Granja.FarmName
$GranjaInformacion.Version = $Granja.ServerVersion
$GranjaInformacion.NumeroServidores = $Servidores.Count
$GranjaInformacion.NumeroAplicaciones = $AplicacionesReport.Count

$GranjaContenido += $GranjaInformacion


####Procesamos el archivo de salida

$HTML_Report = ""
$HTML_Report = InsertarCabeceraHTML

$Enlaces = @("Granja", "Registro de Configuracion", "Administradores", "Aplicaciones", "Directivas", "Directiva de Equilibrio de Carga", "Grupos de Trabajo", "Patrones de Carga", "Servidores", "Zonas")
$HTML_Report = InsertarMenuHTML $HTML_Report $Enlaces

#GRANJA
$TituloColumnas = @("Nombre","Version","Numero de Servidores","Numero de Aplicaciones")
$PropiedadesColumnas = @("Nombre","Version","NumeroServidores","NumeroAplicaciones")
$HTML_Report = InsertarTituloHTML $HTML_Report "Granja"
$HTML_Report = InsertarTablaHTML $HTML_Report "Tabla_Granja" $TituloColumnas $PropiedadesColumnas $GranjaContenido

#REGISTRO DE CONFIGURACIN
If ($RegConfiguracion.LoggingEnabled)
{
	$TituloColumnas = @("Habilitado","Permitir cambios con la bbdd desconectada","Solicitar credenciales","Tipo de Conexion", "Autenticacion", "Usuario", "Servidor", "BBDD")
	$PropiedadesColumnas = @("Habilitado", "Desconectado", "Limpiar", "Tipo", "Autenticacion", "Usuario", "Servidor", "BBDD")
	$HTML_Report = InsertarTituloHTML $HTML_Report "Registro de Configuracion"
	$HTML_Report = InsertarTablaHTML $HTML_Report "Tabla_Reg" $TituloColumnas $PropiedadesColumnas $RegConfiguracionContenido
}
Else
{
	$HTML_Report = InsertarTituloHTML $HTML_Report "Registro de Configuracion"
	$HTML_Report = InsertarTextoHTML $HTML_Report "No est configurado"
}

#ADMINISTRADORES
$TituloColumnas = @("Administrador","Tipo","Habilitado","Permisos en la granja","Permisos en las carpetas")
$PropiedadesColumnas = @("Administrador","Tipo","Habilitado","PermGranja","PermCarpetas")
$HTML_Report = InsertarTituloHTML $HTML_Report "Administradores"
$HTML_Report = InsertarTablaHTML $HTML_Report "Tabla_Admin" $TituloColumnas $PropiedadesColumnas $AdministradoresContenido

#APLICACIONES
$TituloColumnas = @("Nombre", "Tipo", "Carpeta", "Comando", "Directorio de Trabajo", "Usuarios", "Grupos", "Servidores", "Audio", "Encriptacion", "Resolucion", "Color", "Habilitada")
$PropiedadesColumnas = @("Nombre", "Tipo", "Carpeta", "Comando", "Directorio", "Usuarios", "Grupos", "Servidores", "Audio", "Encriptacion", "Resolucion", "Color", "Habilitada")
$HTML_Report = InsertarTituloHTML $HTML_Report "Aplicaciones"
$HTML_Report = InsertarTablaHTML $HTML_Report "Tabla_Aplica" $TituloColumnas $PropiedadesColumnas $AplicacionesContenido

#DIRECTIVAS
$TituloColumnas = @("Nombre", "Descripcin", "Tipo", "Habilitada", "Prioridad", "Filtro", "Configuracion")
$PropiedadesColumnas = @("Nombre", "Descripcion", "Tipo", "Habilitada", "Prioridad", "Filtro", "Configuracion")
$HTML_Report = InsertarTituloHTML $HTML_Report "Directivas"
$HTML_Report = InsertarTablaHTML $HTML_Report "Tabla_Directivas" $TituloColumnas $PropiedadesColumnas $DirectivasContenido

#DIRECTIVAS DE EQUILIBRIO DE CARGA
If ($DirectivasEquilibrioContenido)
{
	$TituloColumnas = @("Nombre", "Descripcion", "Habilitado", "Prioridad", "FiltroAC", "FiltroIP", "FiltroNombre", "FiltroUsuario", "Preferencia")
	$PropiedadesColumnas = @("Nombre", "Descripcion", "Habilitado", "Prioridad", "FiltroAC", "FiltroIP", "FiltroNombre", "FiltroUsuario", "Preferencia")
	$HTML_Report = InsertarTituloHTML $HTML_Report "Directivas de Equilibrio de Carga"
	$HTML_Report = InsertarTablaHTML $HTML_Report "Tabla_Directivas_Carga" $TituloColumnas $PropiedadesColumnas $DirectivasEquilibrioContenido
}
Else
{
	$HTML_Report = InsertarTituloHTML $HTML_Report "Directivas de Equilibrio de Carga"
	$HTML_Report = InsertarTextoHTML $HTML_Report "No hay Directivas de Equilibrio de Carga"
}

#GRUPOS DE TRABAJO
$TituloColumnas = @("Nombre", "Descripcion", "Servidores","Aplicaciones")
$PropiedadesColumnas = @("Nombre", "Descripcion", "Servidores","Aplicaciones")
$HTML_Report = InsertarTituloHTML $HTML_Report "Grupos de Trabajo"
$HTML_Report = InsertarTablaHTML $HTML_Report "Tabla_Grupos" $TituloColumnas $PropiedadesColumnas $GruposDeServidoresContenido

#PATRONES DE CARGA
$TituloColumnas = @("Nombre", "Descripcion", "Tipo", "Reglas")
$PropiedadesColumnas = @("Nombre", "Descripcion", "Tipo", "Reglas")
$HTML_Report = InsertarTituloHTML $HTML_Report "Patrones de Carga"
$HTML_Report = InsertarTablaHTML $HTML_Report "Tabla_Patrones" $TituloColumnas $PropiedadesColumnas $PatronesContenido

#SERVIDORES
$TituloColumnas = @("Nombre", "Versin Citrix", "Sistema Operativo", "Carpeta", "Zona", "Preferencia Eleccion", "Hotfixes")
$PropiedadesColumnas = @("Nombre", "Citrix", "SistemaOperativo", "Carpeta", "Zona", "Eleccion", "Hotfixes")
$HTML_Report = InsertarTituloHTML $HTML_Report "Servidores"
$HTML_Report = InsertarTablaHTML $HTML_Report "Tabla_Servidores" $TituloColumnas $PropiedadesColumnas $ServidoresContenido

#ZONAS
$TituloColumnas = @("Nombre", "DataCollector", "Servidores")
$PropiedadesColumnas = @("Nombre", "DC", "Servidores")
$HTML_Report = InsertarTituloHTML $HTML_Report "Zonas"
$HTML_Report = InsertarTablaHTML $HTML_Report "Tabla_Zonas" $TituloColumnas $PropiedadesColumnas $ZonasContenido




####Finalizando el documento
$ArchivoHTML="./$Granja.html"
$HTML_Report = InsertarFinHTML $HTML_Report
$HTML_Report > $ArchivoHTML

Invoke-Expression $ArchivoHTML